/*
 * Decompiled with CFR 0.152.
 */
package kroppeb.stareval.parser;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import kroppeb.stareval.exception.ParseException;
import kroppeb.stareval.parser.StringReader;

abstract class OpResolver<T> {
    OpResolver() {
    }

    abstract T resolve(StringReader var1) throws ParseException;

    static class SingleDualChar<T>
    extends OpResolver<T> {
        private final T singleCharOperator;
        private final T doubleCharOperator;
        private final char secondChar;

        SingleDualChar(T t, T t2, char c) {
            this.singleCharOperator = t;
            this.doubleCharOperator = t2;
            this.secondChar = c;
        }

        @Override
        T resolve(StringReader stringReader) {
            if (stringReader.tryRead(this.secondChar)) {
                return this.doubleCharOperator;
            }
            return this.singleCharOperator;
        }
    }

    static class DualChar<T>
    extends OpResolver<T> {
        private final T op;
        private final char secondChar;

        DualChar(T t, char c) {
            this.op = t;
            this.secondChar = c;
        }

        @Override
        T resolve(StringReader stringReader) throws ParseException {
            stringReader.read(this.secondChar);
            return this.op;
        }
    }

    static class SingleChar<T>
    extends OpResolver<T> {
        private final T op;

        SingleChar(T t) {
            this.op = t;
        }

        @Override
        T resolve(StringReader stringReader) {
            return this.op;
        }
    }

    static class Builder<T> {
        private final Map<String, T> map = new Object2ObjectOpenHashMap();

        public void singleChar(T t) {
            this.multiChar("", t);
        }

        public void multiChar(String string, T t) {
            T t2 = this.map.put(string, t);
            if (t2 != null) {
                throw new RuntimeException("Tried to add multiple operators that map to the same string.");
            }
        }

        public OpResolver<T> build() {
            if (this.map.size() > 2) {
                throw new RuntimeException("unimplemented: Cannot currently build an optimized operator resolver tree when more than two operators start with the same character");
            }
            T t = this.map.get("");
            if (t != null) {
                if (this.map.size() == 1) {
                    return new SingleChar<T>(t);
                }
                for (Map.Entry<String, T> entry : this.map.entrySet()) {
                    if ("".equals(entry.getKey())) continue;
                    if (entry.getKey().length() != 1) {
                        throw new RuntimeException("unimplemented: Optimized operator resolver trees can currently only be built of operators that contain one or two characters.");
                    }
                    return new SingleDualChar<T>(t, entry.getValue(), entry.getKey().charAt(0));
                }
            } else {
                if (this.map.size() > 1) {
                    throw new RuntimeException("unimplemented: Optimized operator resolver trees can currently only handle two operators starting with the same character if one operator is a single character");
                }
                Iterator<Map.Entry<String, T>> iterator = this.map.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, T> entry = iterator.next();
                    if (entry.getKey().length() != 1) {
                        throw new RuntimeException("unimplemented: Optimized operator resolver trees can currently only be built of operators that contain one or two characters.");
                    }
                    return new DualChar<T>(entry.getValue(), entry.getKey().charAt(0));
                }
            }
            if (this.map.isEmpty()) {
                throw new RuntimeException("Tried to build an operator resolver tree that contains no operators.");
            }
            throw new RuntimeException("This shouldn't be reachable");
        }
    }
}

